<?php
// ----- PDO Connection -----
$host = 'localhost';
$dbname = 'demoptma_solving_publishing';
$username = 'demoptma_solving_publishing';
$password = 'sDHsgS%0P*v]';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// =============================
//  Fetch Invoice Details
// =============================
if (!isset($_GET['id'])) {
    die("Invoice ID missing.");
}

$id = intval($_GET['id']);

$stmt = $pdo->prepare("SELECT * FROM invoices WHERE id = ?");
$stmt->execute([$id]);
$invoice = $stmt->fetch();

if (!$invoice) {
    die("Invoice not found.");
}

// =============================
//  Handle Update Submission
// =============================
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $merchant = $_POST['merchant'];
    $agent = $_POST['agent_name'];
    $clientName = $_POST['client_name'];
    $clientEmail = $_POST['client_email'];
    $clientPhone = $_POST['client_phone'];
    $package = $_POST['package'];
    $amount = floatval($_POST['amount']);

    $update = $pdo->prepare("UPDATE invoices SET 
        merchant = ?, 
        agent_name = ?, 
        client_name = ?, 
        client_email = ?, 
        client_phone = ?, 
        package = ?, 
        amount = ?
        WHERE id = ?
    ");

    $update->execute([
        $merchant, $agent, $clientName, $clientEmail, $clientPhone, $package, $amount, $id
    ]);

    header("Location: invoice.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <link rel="shortcut icon" href="../assets/img/favicon.png" type="image/x-icon">
    <title>Edit Invoice | Solving Publishing</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css"/>

    <style>
        body {
            display: flex;
            min-height: 100vh;
            background: #f4f6f9;
            font-family: "Poppins", sans-serif;
        }
        .sidebar {
            width: 250px;
            background: #043773;
            color: #ecf0f1;
            padding-top: 20px;
            height: 100vh;
            position: fixed;
        }
        .sidebar a {
            display: block;
            color: #ecf0f1;
            padding: 20px 20px;
            text-decoration: none;
            border-bottom: 0.7px solid #ffffff47;
        }
        .sidebar a:hover { background: #34495e; }
        .content { flex-grow: 1; margin-left: 250px; padding: 30px; font-family: "Inter", sans-serif; }
        .sub-inv { background-color: #043773; }
        .sidebar-logo {
            filter: brightness(0.5) invert(1);
        }
    </style>
</head>
<body>

<div class="sidebar">
    <div class="sidebar-logo" style="display:flex;justify-content:center;padding-bottom:3rem;">
        <img src="../assets/img/logo-white.png" width="70%">
    </div>

    
    
    <a href="invoice.php" class="active">Invoice</a>
</div>

<div class="content">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-10">

                <div class="card shadow-lg border-0 rounded-4">
                    <div class="card-body p-4">

                        <h4 class="text-center mb-4 fw-bold" style='font-family: "Poppins", sans-serif;'>
                            Edit Invoice #<?= $invoice['id'] ?>
                        </h4>

                        <form method="post">

                            <div class="mb-3">
                                <label class="form-label">Merchant</label>
                                <select name="merchant" class="form-select" required>
                                    <option value="">Select Merchant</option>
                                    <option value="authorize" 
                                        <?= $invoice['merchant'] === 'authorize' ? 'selected' : '' ?>>
                                        Nexio (Authorize)
                                    </option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Agent Name</label>
                                <input type="text" name="agent_name" class="form-control"
                                       value="<?= htmlspecialchars($invoice['agent_name']) ?>" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Client Name</label>
                                <input type="text" name="client_name" class="form-control"
                                       value="<?= htmlspecialchars($invoice['client_name']) ?>" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" name="client_email" class="form-control"
                                       value="<?= htmlspecialchars($invoice['client_email']) ?>">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Phone</label>
                                <input type="text" name="client_phone" class="form-control"
                                       value="<?= htmlspecialchars($invoice['client_phone']) ?>">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Package</label>
                                <input type="text" name="package" class="form-control"
                                       value="<?= htmlspecialchars($invoice['package']) ?>" required>
                            </div>

                            <div class="mb-4">
                                <label class="form-label">Amount</label>
                                <input type="number" step="0.01" name="amount" class="form-control"
                                       value="<?= htmlspecialchars($invoice['amount']) ?>" required>
                            </div>

                            <div class="d-grid">
                                <button type="submit" class="sub-inv btn btn-success btn-lg rounded-pill">
                                    Update Invoice
                                </button>
                            </div>

                        </form>

                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

</body>
</html>
